﻿using System;
using System.Collections.Generic;
using System.Text;

namespace DeX_Demo_Jun21
{
    /*
     <SuperStarReport>
  <Record>
    <Surname>Aaron</Surname>
    <ChosenName>Chris</ChosenName>
    <DateOfBirth>2005-09-01T00:00:00+01:00</DateOfBirth>
    <Gender>M</Gender>
    <AdmissionNumber>004986</AdmissionNumber>
    <UPN>Y820200109033</UPN>
    <RegGroup>10A</RegGroup>
    <group_code>10</group_code>
    <Salutation>Mr and Mrs Aaron</Salutation>
    <HouseNumber>1</HouseNumber>
    <HouseName>Dunroamin</HouseName>
    <Apartment>20</Apartment>
    <Street>Ely Road</Street>
    <District>Milton</District>
    <Town>Cambridge</Town>
    <County>Cambridgeshire</County>
    <Postcode>CB24 6DD</Postcode>
    <Meal>Free Meal</Meal>
    <free_meal>T</free_meal>
    <free_meal_start>2009-09-02T00:00:00+01:00</free_meal_start>
    <Diet>Artificial colouring allergy, Gluten free, No dairy produce, No nuts of any type/quantity, No pork, Seafood allergy, Vegetarian</Diet>
   <MealPattern>School Meal (Mon), School Meal (Tue), School Meal (Wed), School Meal (Thu), School Meal (Fri)</MealPattern>
     <ID>12105</ID>
   <fsm_transitional_protection>F</fsm_transitional_protection>
  </Record>

     */
    public class QStudent
    {
        public Guid ExternalID;
        /// <summary>
        /// Chosen Surname
        /// </summary>
        public string Surname;
        /// <summary>
        /// Chosen forename
        /// </summary>
        public string ChosenName;
        /// <summary>
        /// Date of Birth
        /// </summary>
        public Nullable<DateTime> DateOfBirth;
        /// <summary>
        /// Single character value for gender
        /// </summary>
        public string Gender;
        /// <summary>
        /// Admission Number
        /// Used as the key to join entities and so can't be blank and useful
        /// </summary>
        public string AdmissionNumber;
        /// <summary>
        /// Universal pupil number - alternative key
        /// </summary>
        public string UPN;
        /// <summary>
        /// Will be returned as Reg Group like SIMS 7
        /// </summary>
        public string CurrentPrimaryClass;
        /// <summary>
        /// NOT REQUIRED
        /// </summary>
        public string CurrentYearGroup;
        /// <summary>
        /// Wanted in numeric only form unless N1, N2, R
        /// returned as group_code
        /// </summary>
        public string CurriculumYear;
        /// <summary>
        /// Parental salutaion for the pupil e.g. Mrs and Mr Bloggs
        /// </summary>
        public string Salutation;
        /// <summary>
        /// House number for pupil address
        /// </summary>
        public string HouseNumber;
        /// <summary>
        /// House name  for pupil address
        /// </summary>
        public string HouseName;
        /// <summary>
        /// Appartment  for pupil address
        /// </summary>
        public string Apartment;
        /// <summary>
        /// Street  for pupil address
        /// </summary>
        public string Street;
        /// <summary>
        /// District  for pupil address
        /// </summary>
        public string District;
        /// <summary>
        /// Town  for pupil address
        /// </summary>
        public string Town;
        /// <summary>
        /// Returned as County  for pupil address
        /// </summary>
        public string AdministrativeArea;
        /// <summary>
        /// Post code For pupil address
        /// </summary>
        public string Postcode;
        /// <summary>
        /// e.g. free meal or sandwiches
        /// </summary>
        public string Meal;
        /// <summary>
        /// A comma separated list of meal options by day
        ///    <MealPattern>School Meal(Mon), School Meal(Tue), School Meal(Wed), School Meal(Thu), School Meal(Fri)</MealPattern>
        /// </summary>
        public string MealPattern;
        /// <summary>
        /// Will contain T or F
        /// </summary>
        public string free_meal;
        public Nullable<DateTime> free_meal_start;
        /// <summary>
        /// List of dietary needs
        /// <Diet>Artificial colouring allergy, Gluten free, No dairy produce, No nuts of any type/quantity, No pork, Seafood allergy, Vegetarian</Diet>
        /// </summary>
        public string Diet;
        /// <summary>
        /// Contains T or F if the latest FSM is based on TP.
        /// </summary>
        public string fsm_transitional_protection;
    }
    /*
      <Record>
    <FullName>Mr Daniel Aaron</FullName>
    <id>11221</id>
    <MainTelephone>07333 181222</MainTelephone>
    <Email>DemoParent@intouchdemo.com</Email>
    <Forename>Daniel</Forename>
    <Surname>Aaron</Surname>
    <Gender>M</Gender>
    <is_a_contact>T</is_a_contact>
    <id1>11221</id1>
    <Priority>2</Priority>
    <AdmissionNumber>004987</AdmissionNumber>
  </Record>
     */
    public class QParent
    {
        /// <summary>
        /// Id field
        /// </summary>
        public string id { get  {return  ExternalID.ToString(); } }
        /// <summary>
        /// ID of the parent
        /// </summary>
        public Guid ExternalID;
        /// <summary>
        /// Full name is read only
        /// </summary>
        public string FullName { get { return Title + " " + Forename + " " + Surname; } }
        /// <summary>
        /// Title of the parent
        /// Contact Basic
        /// </summary>
        public string Title;
        /// <summary>
        /// Surname of the parent
        /// Contact Basic Lookup
        /// </summary>
        public string Surname;
        /// <summary>
        /// Forename of the parent
        /// Contact Basic
        /// </summary>
        public string Forename;
        /// <summary>
        /// Single character value for gender
        /// Contact Basic
        /// </summary>
        public string Gender;
        /// <summary>
        /// All the extract will be parents...
        /// Contact Basic Lookup
        /// </summary>
        public string is_a_contact { get { return "T"; } }
        /// <summary>
        /// Contact priority on relationship
        /// </summary>
        public string Priority;
        /// <summary>
        /// Foriegn key - Student admission Number
        /// </summary>
        public string AdmissionNumber;

    }
    public class XStudent
    {
        public Guid ExternalID;
        public string AdmissionNumber;
        public string UPN;
        public string Surname;
        public string ChosenName;
        public Nullable<DateTime> DateOfBirth;
        public string Gender;
        public string CurrentPrimaryClass;
        public string CurrentYearGroup;
        public string Ethnicity;
        public string free_meal;
        public Nullable<DateTime> free_meal_start;
        public Nullable<DateTime> free_meal_end;
        public string Diet;
        public string Religion;
        public string Apartment;
        public string HouseName;
        public string HouseNumber;
        public string Street;
        public string District;
        public string Town;
        public string AdministrativeArea;
        public string Postcode;
        /// <summary>
        /// 
        /// </summary>
        public string Salutation;
        public string BuildingNumber;
        public string BuildingName;
        public string ContactEmail;
        public string ContactMobile;




        public static string CSVHeader()
        {
            string resp = "AdmissionNumber,UPN,Surname,ChosenName,DateOfBirth,Gender," +
             "Year Group ,RegGroup,Apartment,HouseName,HouseNumber,Street,District," +
             "Town,County,Postcode,Salutation,Ethnicity,Free_meal,Free_meal_start," +
             "Free_meal_end,Diet,Religion,ContactEmail,ContactMobile";

            //string resp = "AdmissionNumber,UPN,Surname,ChosenName,DateOfBirth,Gender," +
            //             "group_code(Year),RegGroup,Ethnicity,free_meal,free_meal_start," +
            //             "free_meal_end,Diet,Religion";

            return resp;
        }

        private static string clean(string s)
        {

            string rc = s == null ? "" : s;
            rc = rc.Replace(",", ";");
            rc = rc.Replace("\"", "'");
            return "\"" + rc + "\"";
        }
        // LA Support Team asked for 'Year ' to be removed from Year 4 
        private string TweakYear(string year)
        {
            if (year.StartsWith("Year ") && year.Length>5)
            {
                return year.Substring(6);
            }
            return year;
        }
        private static string nDateToString(Nullable<DateTime> d)
        {
            StringBuilder b = new StringBuilder();
            if (d == null)
            {
                b.Append("null");
            }
            else
            {
                b.Append(d.Value.Year);
                b.Append("-");
                if (d.Value.Month < 10)
                {
                    b.Append("0");
                }
                b.Append(d.Value.Month);
                b.Append("-");
                if (d.Value.Day < 10)
                {
                    b.Append("0");
                }
                b.Append(d.Value.Day);
            }
            return b.ToString();
        }
        public string ToCSV()
        {
            StringBuilder b = new StringBuilder();
            b.Append(clean(AdmissionNumber)); b.Append(",");
            b.Append(clean(UPN)); b.Append(",");
            b.Append(clean(Surname)); b.Append(",");
            b.Append(clean(ChosenName)); b.Append(",");
            b.Append(nDateToString(DateOfBirth)); b.Append(",");
            b.Append(clean(Gender)); b.Append(",");
            b.Append(clean(TweakYear(CurrentYearGroup))); b.Append(",");
            b.Append(clean(CurrentPrimaryClass)); b.Append(",");
            b.Append(clean(Apartment)); b.Append(",");
            b.Append(clean(HouseName)); b.Append(",");
            b.Append(clean(HouseNumber)); b.Append(",");
            b.Append(clean(Street)); b.Append(",");
            b.Append(clean(District)); b.Append(",");
            b.Append(clean(Town)); b.Append(",");
            b.Append(clean(AdministrativeArea)); b.Append(",");
            b.Append(clean(Postcode)); b.Append(",");
            b.Append(clean(Salutation)); b.Append(",");
            b.Append(clean(Ethnicity)); b.Append(",");
            string fsms = nDateToString(free_meal_start);
            b.Append(fsms == "null" ? "No" : "Yes"); b.Append(",");
            b.Append(fsms); b.Append(",");
            b.Append(nDateToString(free_meal_end)); b.Append(",");
            b.Append(clean(Diet)); b.Append(",");
            b.Append(clean(Religion)); b.Append(",");
            b.Append(clean(ContactEmail)); b.Append(",");
            b.Append(clean(ContactMobile)); b.Append(",");
            return b.ToString();
        }
        public static string XFormat(string name, string value)
        {
            string rc = "";
            if(value != null)
            {
                rc = value;
            }
           // string format = "        <{0}>{1}<{/0}>";
            rc = rc.Replace("&", "&amp;");
            rc = rc.Replace(">", "&gt;");
            rc = rc.Replace("<", "&lt;");
            rc = rc.Replace("'", "&apos;");
            rc = rc.Replace("\"", "&quot;");
            return "        <" + name + ">" + rc + "</" + name + ">";
        }
        public string ToXML()
        {
            StringBuilder b = new StringBuilder();
            b.AppendLine("    <Record>");
            b.AppendLine(XFormat("RecordType", "PUPIL"));
            b.AppendLine(XFormat("AdmissionNumber", AdmissionNumber));
            b.AppendLine(XFormat("ChosenName", ChosenName));
            b.AppendLine(XFormat("DateOfBirth", nDateToString(DateOfBirth)));
            b.AppendLine(XFormat("Ethnicity", Ethnicity));
            string fsms = nDateToString(free_meal_start);
            b.AppendLine(fsms == "null" ? "        <free_meal>F</free_meal>" : "        <free_meal>T</free_meal>");
            b.AppendLine(XFormat("Gender", Gender.Substring(0, 1)));  // Wanted single character
            b.AppendLine(XFormat("group_code", TweakYear(CurrentYearGroup)));
            b.AppendLine(XFormat("HouseNumber", HouseNumber));
            b.AppendLine(XFormat("Postcode", Postcode));
            b.AppendLine(XFormat("RegGroup",CurrentPrimaryClass));
            //b.AppendLine(XFormat("Apartment",Apartment));
            //b.AppendLine("HouseName",XFormat(HouseName));
            b.AppendLine(XFormat("Street", Street));
            //b.AppendLine(XFormat("District",District));
            b.AppendLine(XFormat("Surname", Surname));
            b.AppendLine(XFormat("Town",Town));
            b.AppendLine(XFormat("UPN", UPN));
            //b.AppendLine(XFormat("AdministrativeArea", AdministrativeArea));
            //b.AppendLine(XFormat("Salutation", Salutation));
            // b.AppendLine(XFormat("FSMStart",fsms));
            //b.AppendLine(XFormat("FSMEnd",nDateToString(free_meal_end)));
            //b.AppendLine(XFormat("Diet",Diet));
            //b.AppendLine(XFormat("Religion",Religion));
            //b.AppendLine(XFormat("ContactEmail",ContactEmail));
            //b.AppendLine(XFormat("ContactMobile", ContactMobile));
            b.AppendLine(XFormat("Telephones", ""));
            b.AppendLine(XFormat("ContactList", ""));

            b.AppendLine("    </Record>");
            return b.ToString();
        }
    }

}
